package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseSnapshotsResponse(
    relationalDatabaseSnapshots: Optional[
      Iterable[zio.aws.lightsail.model.RelationalDatabaseSnapshot]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse = {
    import GetRelationalDatabaseSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
      .builder()
      .optionallyWith(
        relationalDatabaseSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationalDatabaseSnapshots)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse(
        relationalDatabaseSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def relationalDatabaseSnapshots: Optional[
      List[zio.aws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly]
    ]
    def nextPageToken: Optional[String]
    def getRelationalDatabaseSnapshots: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relationalDatabaseSnapshots",
      relationalDatabaseSnapshots
    )
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly {
    override val relationalDatabaseSnapshots: Optional[
      List[zio.aws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relationalDatabaseSnapshots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.RelationalDatabaseSnapshot.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
