package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.IsoDate
import scala.jdk.CollectionConverters._
final case class HostKeyAttributes(
    algorithm: Optional[String] = Optional.Absent,
    publicKey: Optional[String] = Optional.Absent,
    witnessedAt: Optional[IsoDate] = Optional.Absent,
    fingerprintSHA1: Optional[String] = Optional.Absent,
    fingerprintSHA256: Optional[String] = Optional.Absent,
    notValidBefore: Optional[IsoDate] = Optional.Absent,
    notValidAfter: Optional[IsoDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.HostKeyAttributes = {
    import HostKeyAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.HostKeyAttributes
      .builder()
      .optionallyWith(algorithm.map(value => value: java.lang.String))(
        _.algorithm
      )
      .optionallyWith(publicKey.map(value => value: java.lang.String))(
        _.publicKey
      )
      .optionallyWith(witnessedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.witnessedAt
      )
      .optionallyWith(fingerprintSHA1.map(value => value: java.lang.String))(
        _.fingerprintSHA1
      )
      .optionallyWith(fingerprintSHA256.map(value => value: java.lang.String))(
        _.fingerprintSHA256
      )
      .optionallyWith(
        notValidBefore.map(value => IsoDate.unwrap(value): Instant)
      )(_.notValidBefore)
      .optionallyWith(
        notValidAfter.map(value => IsoDate.unwrap(value): Instant)
      )(_.notValidAfter)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.HostKeyAttributes.ReadOnly =
    zio.aws.lightsail.model.HostKeyAttributes.wrap(buildAwsValue())
}
object HostKeyAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.HostKeyAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.HostKeyAttributes =
      zio.aws.lightsail.model.HostKeyAttributes(
        algorithm.map(value => value),
        publicKey.map(value => value),
        witnessedAt.map(value => value),
        fingerprintSHA1.map(value => value),
        fingerprintSHA256.map(value => value),
        notValidBefore.map(value => value),
        notValidAfter.map(value => value)
      )
    def algorithm: Optional[String]
    def publicKey: Optional[String]
    def witnessedAt: Optional[IsoDate]
    def fingerprintSHA1: Optional[String]
    def fingerprintSHA256: Optional[String]
    def notValidBefore: Optional[IsoDate]
    def notValidAfter: Optional[IsoDate]
    def getAlgorithm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("algorithm", algorithm)
    def getPublicKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getWitnessedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("witnessedAt", witnessedAt)
    def getFingerprintSHA1: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fingerprintSHA1", fingerprintSHA1)
    def getFingerprintSHA256: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fingerprintSHA256", fingerprintSHA256)
    def getNotValidBefore: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notValidBefore", notValidBefore)
    def getNotValidAfter: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notValidAfter", notValidAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.HostKeyAttributes
  ) extends zio.aws.lightsail.model.HostKeyAttributes.ReadOnly {
    override val algorithm: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithm())
      .map(value => value: String)
    override val publicKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicKey())
      .map(value => value: String)
    override val witnessedAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.witnessedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val fingerprintSHA1: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fingerprintSHA1())
      .map(value => value: String)
    override val fingerprintSHA256: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fingerprintSHA256())
      .map(value => value: String)
    override val notValidBefore: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.notValidBefore())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val notValidAfter: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.notValidAfter())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.HostKeyAttributes
  ): zio.aws.lightsail.model.HostKeyAttributes.ReadOnly = new Wrapper(impl)
}
