package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait InstanceHealthReason {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason
}
object InstanceHealthReason {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.InstanceHealthReason
  ): zio.aws.lightsail.model.InstanceHealthReason = value match {
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.LB_REGISTRATION_IN_PROGRESS =>
      val r = `Lb.RegistrationInProgress`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.LB_INITIAL_HEALTH_CHECKING =>
      val r = `Lb.InitialHealthChecking`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.LB_INTERNAL_ERROR =>
      val r = `Lb.InternalError`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_RESPONSE_CODE_MISMATCH =>
      val r = `Instance.ResponseCodeMismatch`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_TIMEOUT =>
      val r = `Instance.Timeout`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_FAILED_HEALTH_CHECKS =>
      val r = `Instance.FailedHealthChecks`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_NOT_REGISTERED =>
      val r = `Instance.NotRegistered`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_NOT_IN_USE =>
      val r = `Instance.NotInUse`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_DEREGISTRATION_IN_PROGRESS =>
      val r = `Instance.DeregistrationInProgress`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_INVALID_STATE =>
      val r = `Instance.InvalidState`
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_IP_UNUSABLE =>
      val r = `Instance.IpUnusable`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.UNKNOWN_TO_SDK_VERSION
  }
  case object `Lb.RegistrationInProgress`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.LB_REGISTRATION_IN_PROGRESS
  }
  case object `Lb.InitialHealthChecking`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.LB_INITIAL_HEALTH_CHECKING
  }
  case object `Lb.InternalError`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.LB_INTERNAL_ERROR
  }
  case object `Instance.ResponseCodeMismatch`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_RESPONSE_CODE_MISMATCH
  }
  case object `Instance.Timeout`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_TIMEOUT
  }
  case object `Instance.FailedHealthChecks`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_FAILED_HEALTH_CHECKS
  }
  case object `Instance.NotRegistered`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_NOT_REGISTERED
  }
  case object `Instance.NotInUse`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_NOT_IN_USE
  }
  case object `Instance.DeregistrationInProgress`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_DEREGISTRATION_IN_PROGRESS
  }
  case object `Instance.InvalidState`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_INVALID_STATE
  }
  case object `Instance.IpUnusable`
      extends zio.aws.lightsail.model.InstanceHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthReason =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthReason.INSTANCE_IP_UNUSABLE
  }
}
