package zio.aws.lightsail.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.Port
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstancePortInfo(
    fromPort: Optional[Port] = Optional.Absent,
    toPort: Optional[Port] = Optional.Absent,
    protocol: Optional[zio.aws.lightsail.model.NetworkProtocol] =
      Optional.Absent,
    accessFrom: Optional[String] = Optional.Absent,
    accessType: Optional[zio.aws.lightsail.model.PortAccessType] =
      Optional.Absent,
    commonName: Optional[String] = Optional.Absent,
    accessDirection: Optional[zio.aws.lightsail.model.AccessDirection] =
      Optional.Absent,
    cidrs: Optional[Iterable[String]] = Optional.Absent,
    ipv6Cidrs: Optional[Iterable[String]] = Optional.Absent,
    cidrListAliases: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstancePortInfo = {
    import InstancePortInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstancePortInfo
      .builder()
      .optionallyWith(fromPort.map(value => Port.unwrap(value): Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => Port.unwrap(value): Integer))(
        _.toPort
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(accessFrom.map(value => value: java.lang.String))(
        _.accessFrom
      )
      .optionallyWith(accessType.map(value => value.unwrap))(_.accessType)
      .optionallyWith(commonName.map(value => value: java.lang.String))(
        _.commonName
      )
      .optionallyWith(accessDirection.map(value => value.unwrap))(
        _.accessDirection
      )
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(
        ipv6Cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Cidrs)
      .optionallyWith(
        cidrListAliases.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrListAliases)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstancePortInfo.ReadOnly =
    zio.aws.lightsail.model.InstancePortInfo.wrap(buildAwsValue())
}
object InstancePortInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstancePortInfo =
      zio.aws.lightsail.model.InstancePortInfo(
        fromPort.map(value => value),
        toPort.map(value => value),
        protocol.map(value => value),
        accessFrom.map(value => value),
        accessType.map(value => value),
        commonName.map(value => value),
        accessDirection.map(value => value),
        cidrs.map(value => value),
        ipv6Cidrs.map(value => value),
        cidrListAliases.map(value => value)
      )
    def fromPort: Optional[Port]
    def toPort: Optional[Port]
    def protocol: Optional[zio.aws.lightsail.model.NetworkProtocol]
    def accessFrom: Optional[String]
    def accessType: Optional[zio.aws.lightsail.model.PortAccessType]
    def commonName: Optional[String]
    def accessDirection: Optional[zio.aws.lightsail.model.AccessDirection]
    def cidrs: Optional[List[String]]
    def ipv6Cidrs: Optional[List[String]]
    def cidrListAliases: Optional[List[String]]
    def getFromPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.NetworkProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getAccessFrom: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessFrom", accessFrom)
    def getAccessType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.PortAccessType] =
      AwsError.unwrapOptionField("accessType", accessType)
    def getCommonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("commonName", commonName)
    def getAccessDirection
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AccessDirection] =
      AwsError.unwrapOptionField("accessDirection", accessDirection)
    def getCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getIpv6Cidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Cidrs", ipv6Cidrs)
    def getCidrListAliases: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrListAliases", cidrListAliases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ) extends zio.aws.lightsail.model.InstancePortInfo.ReadOnly {
    override val fromPort: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => zio.aws.lightsail.model.primitives.Port(value))
    override val toPort: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => zio.aws.lightsail.model.primitives.Port(value))
    override val protocol: Optional[zio.aws.lightsail.model.NetworkProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.lightsail.model.NetworkProtocol.wrap(value))
    override val accessFrom: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accessFrom())
      .map(value => value: String)
    override val accessType: Optional[zio.aws.lightsail.model.PortAccessType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessType())
        .map(value => zio.aws.lightsail.model.PortAccessType.wrap(value))
    override val commonName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.commonName())
      .map(value => value: String)
    override val accessDirection
        : Optional[zio.aws.lightsail.model.AccessDirection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessDirection())
        .map(value => zio.aws.lightsail.model.AccessDirection.wrap(value))
    override val cidrs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ipv6Cidrs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cidrListAliases: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrListAliases())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ): zio.aws.lightsail.model.InstancePortInfo.ReadOnly = new Wrapper(impl)
}
