package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceSnapshotInfo(
    fromBundleId: Optional[NonEmptyString] = Optional.Absent,
    fromBlueprintId: Optional[NonEmptyString] = Optional.Absent,
    fromDiskInfo: Optional[Iterable[zio.aws.lightsail.model.DiskInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo = {
    import InstanceSnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
      .builder()
      .optionallyWith(
        fromBundleId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromBundleId)
      .optionallyWith(
        fromBlueprintId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromBlueprintId)
      .optionallyWith(
        fromDiskInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fromDiskInfo)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly =
    zio.aws.lightsail.model.InstanceSnapshotInfo.wrap(buildAwsValue())
}
object InstanceSnapshotInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceSnapshotInfo =
      zio.aws.lightsail.model.InstanceSnapshotInfo(
        fromBundleId.map(value => value),
        fromBlueprintId.map(value => value),
        fromDiskInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fromBundleId: Optional[NonEmptyString]
    def fromBlueprintId: Optional[NonEmptyString]
    def fromDiskInfo: Optional[List[zio.aws.lightsail.model.DiskInfo.ReadOnly]]
    def getFromBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromBundleId", fromBundleId)
    def getFromBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromBlueprintId", fromBlueprintId)
    def getFromDiskInfo
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.DiskInfo.ReadOnly]] =
      AwsError.unwrapOptionField("fromDiskInfo", fromDiskInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ) extends zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly {
    override val fromBundleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.fromBundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromBlueprintId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromBlueprintId())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromDiskInfo
        : Optional[List[zio.aws.lightsail.model.DiskInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromDiskInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.DiskInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ): zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly = new Wrapper(impl)
}
