package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MonthlyTransfer(
    gbPerMonthAllocated: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.MonthlyTransfer = {
    import MonthlyTransfer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
      .builder()
      .optionallyWith(
        gbPerMonthAllocated.map(value => value: java.lang.Integer)
      )(_.gbPerMonthAllocated)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.MonthlyTransfer.ReadOnly =
    zio.aws.lightsail.model.MonthlyTransfer.wrap(buildAwsValue())
}
object MonthlyTransfer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.MonthlyTransfer =
      zio.aws.lightsail.model
        .MonthlyTransfer(gbPerMonthAllocated.map(value => value))
    def gbPerMonthAllocated: Optional[Integer]
    def getGbPerMonthAllocated: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gbPerMonthAllocated", gbPerMonthAllocated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ) extends zio.aws.lightsail.model.MonthlyTransfer.ReadOnly {
    override val gbPerMonthAllocated: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.gbPerMonthAllocated())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ): zio.aws.lightsail.model.MonthlyTransfer.ReadOnly = new Wrapper(impl)
}
