package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAlarmRequest(
    alarmName: ResourceName,
    metricName: zio.aws.lightsail.model.MetricName,
    monitoredResourceName: ResourceName,
    comparisonOperator: zio.aws.lightsail.model.ComparisonOperator,
    threshold: Double,
    evaluationPeriods: Integer,
    datapointsToAlarm: Optional[Integer] = Optional.Absent,
    treatMissingData: Optional[zio.aws.lightsail.model.TreatMissingData] =
      Optional.Absent,
    contactProtocols: Optional[
      Iterable[zio.aws.lightsail.model.ContactProtocol]
    ] = Optional.Absent,
    notificationTriggers: Optional[
      Iterable[zio.aws.lightsail.model.AlarmState]
    ] = Optional.Absent,
    notificationEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PutAlarmRequest = {
    import PutAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PutAlarmRequest
      .builder()
      .alarmName(ResourceName.unwrap(alarmName): java.lang.String)
      .metricName(metricName.unwrap)
      .monitoredResourceName(
        ResourceName.unwrap(monitoredResourceName): java.lang.String
      )
      .comparisonOperator(comparisonOperator.unwrap)
      .threshold(threshold: java.lang.Double)
      .evaluationPeriods(evaluationPeriods: java.lang.Integer)
      .optionallyWith(datapointsToAlarm.map(value => value: java.lang.Integer))(
        _.datapointsToAlarm
      )
      .optionallyWith(treatMissingData.map(value => value.unwrap))(
        _.treatMissingData
      )
      .optionallyWith(
        contactProtocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contactProtocolsWithStrings)
      .optionallyWith(
        notificationTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationTriggersWithStrings)
      .optionallyWith(
        notificationEnabled.map(value => value: java.lang.Boolean)
      )(_.notificationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.PutAlarmRequest.ReadOnly =
    zio.aws.lightsail.model.PutAlarmRequest.wrap(buildAwsValue())
}
object PutAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PutAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.PutAlarmRequest =
      zio.aws.lightsail.model.PutAlarmRequest(
        alarmName,
        metricName,
        monitoredResourceName,
        comparisonOperator,
        threshold,
        evaluationPeriods,
        datapointsToAlarm.map(value => value),
        treatMissingData.map(value => value),
        contactProtocols.map(value => value),
        notificationTriggers.map(value => value),
        notificationEnabled.map(value => value)
      )
    def alarmName: ResourceName
    def metricName: zio.aws.lightsail.model.MetricName
    def monitoredResourceName: ResourceName
    def comparisonOperator: zio.aws.lightsail.model.ComparisonOperator
    def threshold: Double
    def evaluationPeriods: Integer
    def datapointsToAlarm: Optional[Integer]
    def treatMissingData: Optional[zio.aws.lightsail.model.TreatMissingData]
    def contactProtocols
        : Optional[List[zio.aws.lightsail.model.ContactProtocol]]
    def notificationTriggers: Optional[List[zio.aws.lightsail.model.AlarmState]]
    def notificationEnabled: Optional[Boolean]
    def getAlarmName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(alarmName)
    def getMetricName: ZIO[Any, Nothing, zio.aws.lightsail.model.MetricName] =
      ZIO.succeed(metricName)
    def getMonitoredResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(monitoredResourceName)
    def getComparisonOperator
        : ZIO[Any, Nothing, zio.aws.lightsail.model.ComparisonOperator] =
      ZIO.succeed(comparisonOperator)
    def getThreshold: ZIO[Any, Nothing, Double] = ZIO.succeed(threshold)
    def getEvaluationPeriods: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(evaluationPeriods)
    def getDatapointsToAlarm: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarm)
    def getTreatMissingData
        : ZIO[Any, AwsError, zio.aws.lightsail.model.TreatMissingData] =
      AwsError.unwrapOptionField("treatMissingData", treatMissingData)
    def getContactProtocols
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.ContactProtocol]] =
      AwsError.unwrapOptionField("contactProtocols", contactProtocols)
    def getNotificationTriggers
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AlarmState]] =
      AwsError.unwrapOptionField("notificationTriggers", notificationTriggers)
    def getNotificationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("notificationEnabled", notificationEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PutAlarmRequest
  ) extends zio.aws.lightsail.model.PutAlarmRequest.ReadOnly {
    override val alarmName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.alarmName())
    override val metricName: zio.aws.lightsail.model.MetricName =
      zio.aws.lightsail.model.MetricName.wrap(impl.metricName())
    override val monitoredResourceName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.monitoredResourceName())
    override val comparisonOperator
        : zio.aws.lightsail.model.ComparisonOperator =
      zio.aws.lightsail.model.ComparisonOperator.wrap(impl.comparisonOperator())
    override val threshold: Double = impl.threshold(): Double
    override val evaluationPeriods: Integer = impl.evaluationPeriods(): Integer
    override val datapointsToAlarm: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.datapointsToAlarm())
      .map(value => value: Integer)
    override val treatMissingData
        : Optional[zio.aws.lightsail.model.TreatMissingData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatMissingData())
        .map(value => zio.aws.lightsail.model.TreatMissingData.wrap(value))
    override val contactProtocols
        : Optional[List[zio.aws.lightsail.model.ContactProtocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactProtocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.ContactProtocol.wrap(item)
          }.toList
        )
    override val notificationTriggers
        : Optional[List[zio.aws.lightsail.model.AlarmState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AlarmState.wrap(item)
          }.toList
        )
    override val notificationEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PutAlarmRequest
  ): zio.aws.lightsail.model.PutAlarmRequest.ReadOnly = new Wrapper(impl)
}
