package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RelationalDatabaseHardware(
    cpuCount: Optional[Integer] = Optional.Absent,
    diskSizeInGb: Optional[Integer] = Optional.Absent,
    ramSizeInGb: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware = {
    import RelationalDatabaseHardware.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
      .builder()
      .optionallyWith(cpuCount.map(value => value: java.lang.Integer))(
        _.cpuCount
      )
      .optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(
        _.diskSizeInGb
      )
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseHardware.wrap(buildAwsValue())
}
object RelationalDatabaseHardware {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseHardware =
      zio.aws.lightsail.model.RelationalDatabaseHardware(
        cpuCount.map(value => value),
        diskSizeInGb.map(value => value),
        ramSizeInGb.map(value => value)
      )
    def cpuCount: Optional[Integer]
    def diskSizeInGb: Optional[Integer]
    def ramSizeInGb: Optional[Float]
    def getCpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCount)
    def getDiskSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGb)
    def getRamSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ) extends zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly {
    override val cpuCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cpuCount())
      .map(value => value: Integer)
    override val diskSizeInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.diskSizeInGb())
      .map(value => value: Integer)
    override val ramSizeInGb: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.ramSizeInGb())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ): zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly = new Wrapper(
    impl
  )
}
