package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait RenewalStatus {
  def unwrap: software.amazon.awssdk.services.lightsail.model.RenewalStatus
}
object RenewalStatus {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.RenewalStatus
  ): zio.aws.lightsail.model.RenewalStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.PENDING_AUTO_RENEWAL =>
      val r = PendingAutoRenewal
      r
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.PENDING_VALIDATION =>
      val r = PendingValidation
      r
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PendingAutoRenewal extends zio.aws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.PENDING_AUTO_RENEWAL
  }
  case object PendingValidation extends zio.aws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.PENDING_VALIDATION
  }
  case object Success extends zio.aws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.SUCCESS
  }
  case object Failed extends zio.aws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.FAILED
  }
}
