package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{BucketName, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetResourceAccessForBucketRequest(
    resourceName: ResourceName,
    bucketName: BucketName,
    access: zio.aws.lightsail.model.ResourceBucketAccess
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest = {
    import SetResourceAccessForBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .access(access.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.SetResourceAccessForBucketRequest.ReadOnly =
    zio.aws.lightsail.model.SetResourceAccessForBucketRequest
      .wrap(buildAwsValue())
}
object SetResourceAccessForBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.SetResourceAccessForBucketRequest =
      zio.aws.lightsail.model
        .SetResourceAccessForBucketRequest(resourceName, bucketName, access)
    def resourceName: ResourceName
    def bucketName: BucketName
    def access: zio.aws.lightsail.model.ResourceBucketAccess
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getAccess
        : ZIO[Any, Nothing, zio.aws.lightsail.model.ResourceBucketAccess] =
      ZIO.succeed(access)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest
  ) extends zio.aws.lightsail.model.SetResourceAccessForBucketRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
    override val access: zio.aws.lightsail.model.ResourceBucketAccess =
      zio.aws.lightsail.model.ResourceBucketAccess.wrap(impl.access())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest
  ): zio.aws.lightsail.model.SetResourceAccessForBucketRequest.ReadOnly =
    new Wrapper(impl)
}
