package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IpAddress,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class StaticIp(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    attachedTo: Optional[ResourceName] = Optional.Absent,
    isAttached: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StaticIp = {
    import StaticIp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StaticIp
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        attachedTo.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.attachedTo)
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.StaticIp.ReadOnly =
    zio.aws.lightsail.model.StaticIp.wrap(buildAwsValue())
}
object StaticIp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StaticIp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StaticIp =
      zio.aws.lightsail.model.StaticIp(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        ipAddress.map(value => value),
        attachedTo.map(value => value),
        isAttached.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def ipAddress: Optional[IpAddress]
    def attachedTo: Optional[ResourceName]
    def isAttached: Optional[Boolean]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getAttachedTo: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("attachedTo", attachedTo)
    def getIsAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttached)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StaticIp
  ) extends zio.aws.lightsail.model.StaticIp.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.lightsail.model.primitives.IpAddress(value))
    override val attachedTo: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedTo())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val isAttached: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAttached())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StaticIp
  ): zio.aws.lightsail.model.StaticIp.ReadOnly = new Wrapper(impl)
}
