package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBucketResponse(
    bucket: Optional[zio.aws.lightsail.model.Bucket] = Optional.Absent,
    operations: Optional[Iterable[zio.aws.lightsail.model.Operation]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse = {
    import UpdateBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse
      .builder()
      .optionallyWith(bucket.map(value => value.buildAwsValue()))(_.bucket)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly =
    zio.aws.lightsail.model.UpdateBucketResponse.wrap(buildAwsValue())
}
object UpdateBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateBucketResponse =
      zio.aws.lightsail.model.UpdateBucketResponse(
        bucket.map(value => value.asEditable),
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bucket: Optional[zio.aws.lightsail.model.Bucket.ReadOnly]
    def operations: Optional[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getBucket: ZIO[Any, AwsError, zio.aws.lightsail.model.Bucket.ReadOnly] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse
  ) extends zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly {
    override val bucket: Optional[zio.aws.lightsail.model.Bucket.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucket())
        .map(value => zio.aws.lightsail.model.Bucket.wrap(value))
    override val operations
        : Optional[List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Operation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse
  ): zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly = new Wrapper(impl)
}
