package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateContainerServiceResponse(
    containerService: Optional[zio.aws.lightsail.model.ContainerService] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse = {
    import UpdateContainerServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse
      .builder()
      .optionallyWith(containerService.map(value => value.buildAwsValue()))(
        _.containerService
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateContainerServiceResponse.ReadOnly =
    zio.aws.lightsail.model.UpdateContainerServiceResponse.wrap(buildAwsValue())
}
object UpdateContainerServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateContainerServiceResponse =
      zio.aws.lightsail.model.UpdateContainerServiceResponse(
        containerService.map(value => value.asEditable)
      )
    def containerService
        : Optional[zio.aws.lightsail.model.ContainerService.ReadOnly]
    def getContainerService: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerService.ReadOnly
    ] = AwsError.unwrapOptionField("containerService", containerService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse
  ) extends zio.aws.lightsail.model.UpdateContainerServiceResponse.ReadOnly {
    override val containerService
        : Optional[zio.aws.lightsail.model.ContainerService.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerService())
        .map(value => zio.aws.lightsail.model.ContainerService.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse
  ): zio.aws.lightsail.model.UpdateContainerServiceResponse.ReadOnly =
    new Wrapper(impl)
}
