package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateDomainEntryRequest(
    domainName: DomainName,
    domainEntry: zio.aws.lightsail.model.DomainEntry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest = {
    import UpdateDomainEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .domainEntry(domainEntry.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.UpdateDomainEntryRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateDomainEntryRequest.wrap(buildAwsValue())
}
object UpdateDomainEntryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateDomainEntryRequest =
      zio.aws.lightsail.model
        .UpdateDomainEntryRequest(domainName, domainEntry.asEditable)
    def domainName: DomainName
    def domainEntry: zio.aws.lightsail.model.DomainEntry.ReadOnly
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getDomainEntry
        : ZIO[Any, Nothing, zio.aws.lightsail.model.DomainEntry.ReadOnly] =
      ZIO.succeed(domainEntry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest
  ) extends zio.aws.lightsail.model.UpdateDomainEntryRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.lightsail.model.primitives.DomainName(impl.domainName())
    override val domainEntry: zio.aws.lightsail.model.DomainEntry.ReadOnly =
      zio.aws.lightsail.model.DomainEntry.wrap(impl.domainEntry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest
  ): zio.aws.lightsail.model.UpdateDomainEntryRequest.ReadOnly = new Wrapper(
    impl
  )
}
