package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachInstancesToLoadBalancerRequest(
    loadBalancerName: ResourceName,
    instanceNames: Iterable[ResourceName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest = {
    import AttachInstancesToLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .instanceNames(instanceNames.map { item =>
        ResourceName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.AttachInstancesToLoadBalancerRequest.ReadOnly =
    zio.aws.lightsail.model.AttachInstancesToLoadBalancerRequest
      .wrap(buildAwsValue())
}
object AttachInstancesToLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.AttachInstancesToLoadBalancerRequest =
      zio.aws.lightsail.model
        .AttachInstancesToLoadBalancerRequest(loadBalancerName, instanceNames)
    def loadBalancerName: ResourceName
    def instanceNames: List[ResourceName]
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
    def getInstanceNames: ZIO[Any, Nothing, List[ResourceName]] =
      ZIO.succeed(instanceNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest
  ) extends zio.aws.lightsail.model.AttachInstancesToLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
    override val instanceNames: List[ResourceName] = impl
      .instanceNames()
      .asScala
      .map { item =>
        zio.aws.lightsail.model.primitives.ResourceName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest
  ): zio.aws.lightsail.model.AttachInstancesToLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
