package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BucketState(
    code: Optional[NonEmptyString] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketState = {
    import BucketState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketState
      .builder()
      .optionallyWith(
        code.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.BucketState.ReadOnly =
    zio.aws.lightsail.model.BucketState.wrap(buildAwsValue())
}
object BucketState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.BucketState =
      zio.aws.lightsail.model
        .BucketState(code.map(value => value), message.map(value => value))
    def code: Optional[NonEmptyString]
    def message: Optional[String]
    def getCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketState
  ) extends zio.aws.lightsail.model.BucketState.ReadOnly {
    override val code: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketState
  ): zio.aws.lightsail.model.BucketState.ReadOnly = new Wrapper(impl)
}
