package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CacheBehaviorPerPath(
    path: Optional[String] = Optional.Absent,
    behavior: Optional[zio.aws.lightsail.model.BehaviorEnum] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath = {
    import CacheBehaviorPerPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath
      .builder()
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(behavior.map(value => value.unwrap))(_.behavior)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly =
    zio.aws.lightsail.model.CacheBehaviorPerPath.wrap(buildAwsValue())
}
object CacheBehaviorPerPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CacheBehaviorPerPath =
      zio.aws.lightsail.model.CacheBehaviorPerPath(
        path.map(value => value),
        behavior.map(value => value)
      )
    def path: Optional[String]
    def behavior: Optional[zio.aws.lightsail.model.BehaviorEnum]
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getBehavior: ZIO[Any, AwsError, zio.aws.lightsail.model.BehaviorEnum] =
      AwsError.unwrapOptionField("behavior", behavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath
  ) extends zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly {
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val behavior: Optional[zio.aws.lightsail.model.BehaviorEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behavior())
        .map(value => zio.aws.lightsail.model.BehaviorEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath
  ): zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly = new Wrapper(impl)
}
