package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  SerialNumber,
  IssuerCA,
  IsoDate,
  EligibleToRenew,
  InUseResourceCount,
  DomainName,
  CertificateName,
  RevocationReason,
  KeyAlgorithm,
  RequestFailureReason,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Certificate(
    arn: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[CertificateName] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    status: Optional[zio.aws.lightsail.model.CertificateStatus] =
      Optional.Absent,
    serialNumber: Optional[SerialNumber] = Optional.Absent,
    subjectAlternativeNames: Optional[Iterable[DomainName]] = Optional.Absent,
    domainValidationRecords: Optional[
      Iterable[zio.aws.lightsail.model.DomainValidationRecord]
    ] = Optional.Absent,
    requestFailureReason: Optional[RequestFailureReason] = Optional.Absent,
    inUseResourceCount: Optional[InUseResourceCount] = Optional.Absent,
    keyAlgorithm: Optional[KeyAlgorithm] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    issuedAt: Optional[IsoDate] = Optional.Absent,
    issuerCA: Optional[IssuerCA] = Optional.Absent,
    notBefore: Optional[IsoDate] = Optional.Absent,
    notAfter: Optional[IsoDate] = Optional.Absent,
    eligibleToRenew: Optional[EligibleToRenew] = Optional.Absent,
    renewalSummary: Optional[zio.aws.lightsail.model.RenewalSummary] =
      Optional.Absent,
    revokedAt: Optional[IsoDate] = Optional.Absent,
    revocationReason: Optional[RevocationReason] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Certificate
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => CertificateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        serialNumber.map(value => SerialNumber.unwrap(value): java.lang.String)
      )(_.serialNumber)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            DomainName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationRecords)
      .optionallyWith(
        requestFailureReason.map(value =>
          RequestFailureReason.unwrap(value): java.lang.String
        )
      )(_.requestFailureReason)
      .optionallyWith(
        inUseResourceCount.map(value =>
          InUseResourceCount.unwrap(value): Integer
        )
      )(_.inUseResourceCount)
      .optionallyWith(
        keyAlgorithm.map(value => KeyAlgorithm.unwrap(value): java.lang.String)
      )(_.keyAlgorithm)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(issuedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.issuedAt
      )
      .optionallyWith(
        issuerCA.map(value => IssuerCA.unwrap(value): java.lang.String)
      )(_.issuerCA)
      .optionallyWith(notBefore.map(value => IsoDate.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => IsoDate.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(
        eligibleToRenew.map(value =>
          EligibleToRenew.unwrap(value): java.lang.String
        )
      )(_.eligibleToRenew)
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(revokedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.revokedAt
      )
      .optionallyWith(
        revocationReason.map(value =>
          RevocationReason.unwrap(value): java.lang.String
        )
      )(_.revocationReason)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Certificate.ReadOnly =
    zio.aws.lightsail.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Certificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Certificate =
      zio.aws.lightsail.model.Certificate(
        arn.map(value => value),
        name.map(value => value),
        domainName.map(value => value),
        status.map(value => value),
        serialNumber.map(value => value),
        subjectAlternativeNames.map(value => value),
        domainValidationRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requestFailureReason.map(value => value),
        inUseResourceCount.map(value => value),
        keyAlgorithm.map(value => value),
        createdAt.map(value => value),
        issuedAt.map(value => value),
        issuerCA.map(value => value),
        notBefore.map(value => value),
        notAfter.map(value => value),
        eligibleToRenew.map(value => value),
        renewalSummary.map(value => value.asEditable),
        revokedAt.map(value => value),
        revocationReason.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportCode.map(value => value)
      )
    def arn: Optional[NonEmptyString]
    def name: Optional[CertificateName]
    def domainName: Optional[DomainName]
    def status: Optional[zio.aws.lightsail.model.CertificateStatus]
    def serialNumber: Optional[SerialNumber]
    def subjectAlternativeNames: Optional[List[DomainName]]
    def domainValidationRecords: Optional[
      List[zio.aws.lightsail.model.DomainValidationRecord.ReadOnly]
    ]
    def requestFailureReason: Optional[RequestFailureReason]
    def inUseResourceCount: Optional[InUseResourceCount]
    def keyAlgorithm: Optional[KeyAlgorithm]
    def createdAt: Optional[IsoDate]
    def issuedAt: Optional[IsoDate]
    def issuerCA: Optional[IssuerCA]
    def notBefore: Optional[IsoDate]
    def notAfter: Optional[IsoDate]
    def eligibleToRenew: Optional[EligibleToRenew]
    def renewalSummary
        : Optional[zio.aws.lightsail.model.RenewalSummary.ReadOnly]
    def revokedAt: Optional[IsoDate]
    def revocationReason: Optional[RevocationReason]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def supportCode: Optional[String]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("name", name)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSerialNumber: ZIO[Any, AwsError, SerialNumber] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getDomainValidationRecords: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.DomainValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationRecords",
      domainValidationRecords
    )
    def getRequestFailureReason: ZIO[Any, AwsError, RequestFailureReason] =
      AwsError.unwrapOptionField("requestFailureReason", requestFailureReason)
    def getInUseResourceCount: ZIO[Any, AwsError, InUseResourceCount] =
      AwsError.unwrapOptionField("inUseResourceCount", inUseResourceCount)
    def getKeyAlgorithm: ZIO[Any, AwsError, KeyAlgorithm] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getIssuedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getIssuerCA: ZIO[Any, AwsError, IssuerCA] =
      AwsError.unwrapOptionField("issuerCA", issuerCA)
    def getNotBefore: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getEligibleToRenew: ZIO[Any, AwsError, EligibleToRenew] =
      AwsError.unwrapOptionField("eligibleToRenew", eligibleToRenew)
    def getRenewalSummary
        : ZIO[Any, AwsError, zio.aws.lightsail.model.RenewalSummary.ReadOnly] =
      AwsError.unwrapOptionField("renewalSummary", renewalSummary)
    def getRevokedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
    def getRevocationReason: ZIO[Any, AwsError, RevocationReason] =
      AwsError.unwrapOptionField("revocationReason", revocationReason)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Certificate
  ) extends zio.aws.lightsail.model.Certificate.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val name: Optional[CertificateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.CertificateName(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val status: Optional[zio.aws.lightsail.model.CertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lightsail.model.CertificateStatus.wrap(value))
    override val serialNumber: Optional[SerialNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.serialNumber())
      .map(value => zio.aws.lightsail.model.primitives.SerialNumber(value))
    override val subjectAlternativeNames: Optional[List[DomainName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subjectAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.primitives.DomainName(item)
          }.toList
        )
    override val domainValidationRecords: Optional[
      List[zio.aws.lightsail.model.DomainValidationRecord.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.DomainValidationRecord.wrap(item)
        }.toList
      )
    override val requestFailureReason: Optional[RequestFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestFailureReason())
        .map(value =>
          zio.aws.lightsail.model.primitives.RequestFailureReason(value)
        )
    override val inUseResourceCount: Optional[InUseResourceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inUseResourceCount())
        .map(value =>
          zio.aws.lightsail.model.primitives.InUseResourceCount(value)
        )
    override val keyAlgorithm: Optional[KeyAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.keyAlgorithm())
      .map(value => zio.aws.lightsail.model.primitives.KeyAlgorithm(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val issuedAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.issuedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val issuerCA: Optional[IssuerCA] = zio.aws.core.internal
      .optionalFromNullable(impl.issuerCA())
      .map(value => zio.aws.lightsail.model.primitives.IssuerCA(value))
    override val notBefore: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.notBefore())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val notAfter: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val eligibleToRenew: Optional[EligibleToRenew] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eligibleToRenew())
        .map(value => zio.aws.lightsail.model.primitives.EligibleToRenew(value))
    override val renewalSummary
        : Optional[zio.aws.lightsail.model.RenewalSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renewalSummary())
        .map(value => zio.aws.lightsail.model.RenewalSummary.wrap(value))
    override val revokedAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.revokedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val revocationReason: Optional[RevocationReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revocationReason())
        .map(value =>
          zio.aws.lightsail.model.primitives.RevocationReason(value)
        )
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Certificate
  ): zio.aws.lightsail.model.Certificate.ReadOnly = new Wrapper(impl)
}
