package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  DomainName,
  CertificateName,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CertificateSummary(
    certificateArn: Optional[NonEmptyString] = Optional.Absent,
    certificateName: Optional[CertificateName] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    certificateDetail: Optional[zio.aws.lightsail.model.Certificate] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CertificateSummary = {
    import CertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CertificateSummary
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateName.map(value =>
          CertificateName.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(certificateDetail.map(value => value.buildAwsValue()))(
        _.certificateDetail
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CertificateSummary.ReadOnly =
    zio.aws.lightsail.model.CertificateSummary.wrap(buildAwsValue())
}
object CertificateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CertificateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CertificateSummary =
      zio.aws.lightsail.model.CertificateSummary(
        certificateArn.map(value => value),
        certificateName.map(value => value),
        domainName.map(value => value),
        certificateDetail.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificateArn: Optional[NonEmptyString]
    def certificateName: Optional[CertificateName]
    def domainName: Optional[DomainName]
    def certificateDetail
        : Optional[zio.aws.lightsail.model.Certificate.ReadOnly]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getCertificateArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getCertificateDetail
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Certificate.ReadOnly] =
      AwsError.unwrapOptionField("certificateDetail", certificateDetail)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CertificateSummary
  ) extends zio.aws.lightsail.model.CertificateSummary.ReadOnly {
    override val certificateArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val certificateName: Optional[CertificateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateName())
        .map(value => zio.aws.lightsail.model.primitives.CertificateName(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val certificateDetail
        : Optional[zio.aws.lightsail.model.Certificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateDetail())
        .map(value => zio.aws.lightsail.model.Certificate.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CertificateSummary
  ): zio.aws.lightsail.model.CertificateSummary.ReadOnly = new Wrapper(impl)
}
