package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait CloudFormationStackRecordSourceType {
  def unwrap: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType
}
object CloudFormationStackRecordSourceType {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType
  ): zio.aws.lightsail.model.CloudFormationStackRecordSourceType = value match {
    case software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType.EXPORT_SNAPSHOT_RECORD =>
      val r = ExportSnapshotRecord
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.CloudFormationStackRecordSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType =
      software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ExportSnapshotRecord
      extends zio.aws.lightsail.model.CloudFormationStackRecordSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType =
      software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceType.EXPORT_SNAPSHOT_RECORD
  }
}
