package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, ContainerName, Integer}
import scala.jdk.CollectionConverters._
final case class ContainerServiceDeployment(
    version: Optional[Integer] = Optional.Absent,
    state: Optional[zio.aws.lightsail.model.ContainerServiceDeploymentState] =
      Optional.Absent,
    containers: Optional[
      Map[ContainerName, zio.aws.lightsail.model.Container]
    ] = Optional.Absent,
    publicEndpoint: Optional[zio.aws.lightsail.model.ContainerServiceEndpoint] =
      Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment = {
    import ContainerServiceDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
      .builder()
      .optionallyWith(version.map(value => value: java.lang.Integer))(_.version)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        containers.map(value =>
          value
            .map({ case (key, value) =>
              (ContainerName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.containers)
      .optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(
        _.publicEndpoint
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceDeployment.wrap(buildAwsValue())
}
object ContainerServiceDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceDeployment =
      zio.aws.lightsail.model.ContainerServiceDeployment(
        version.map(value => value),
        state.map(value => value),
        containers.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        publicEndpoint.map(value => value.asEditable),
        createdAt.map(value => value)
      )
    def version: Optional[Integer]
    def state: Optional[zio.aws.lightsail.model.ContainerServiceDeploymentState]
    def containers: Optional[
      Map[ContainerName, zio.aws.lightsail.model.Container.ReadOnly]
    ]
    def publicEndpoint
        : Optional[zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly]
    def createdAt: Optional[IsoDate]
    def getVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("version", version)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceDeploymentState
    ] = AwsError.unwrapOptionField("state", state)
    def getContainers: ZIO[Any, AwsError, Map[
      ContainerName,
      zio.aws.lightsail.model.Container.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getPublicEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("publicEndpoint", publicEndpoint)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ) extends zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly {
    override val version: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: Integer)
    override val state
        : Optional[zio.aws.lightsail.model.ContainerServiceDeploymentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceDeploymentState.wrap(value)
        )
    override val containers: Optional[
      Map[ContainerName, zio.aws.lightsail.model.Container.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lightsail.model.primitives.ContainerName(
              key
            ) -> zio.aws.lightsail.model.Container.wrap(value)
          })
          .toMap
      )
    override val publicEndpoint
        : Optional[zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicEndpoint())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceEndpoint.wrap(value)
        )
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ): zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly = new Wrapper(
    impl
  )
}
