package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ContainerName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerServiceDeploymentRequest(
    containers: Optional[
      Map[ContainerName, zio.aws.lightsail.model.Container]
    ] = Optional.Absent,
    publicEndpoint: Optional[zio.aws.lightsail.model.EndpointRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest = {
    import ContainerServiceDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest
      .builder()
      .optionallyWith(
        containers.map(value =>
          value
            .map({ case (key, value) =>
              (ContainerName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.containers)
      .optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(
        _.publicEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceDeploymentRequest
      .wrap(buildAwsValue())
}
object ContainerServiceDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceDeploymentRequest =
      zio.aws.lightsail.model.ContainerServiceDeploymentRequest(
        containers.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        publicEndpoint.map(value => value.asEditable)
      )
    def containers: Optional[
      Map[ContainerName, zio.aws.lightsail.model.Container.ReadOnly]
    ]
    def publicEndpoint
        : Optional[zio.aws.lightsail.model.EndpointRequest.ReadOnly]
    def getContainers: ZIO[Any, AwsError, Map[
      ContainerName,
      zio.aws.lightsail.model.Container.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getPublicEndpoint
        : ZIO[Any, AwsError, zio.aws.lightsail.model.EndpointRequest.ReadOnly] =
      AwsError.unwrapOptionField("publicEndpoint", publicEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest
  ) extends zio.aws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly {
    override val containers: Optional[
      Map[ContainerName, zio.aws.lightsail.model.Container.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lightsail.model.primitives.ContainerName(
              key
            ) -> zio.aws.lightsail.model.Container.wrap(value)
          })
          .toMap
      )
    override val publicEndpoint
        : Optional[zio.aws.lightsail.model.EndpointRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicEndpoint())
        .map(value => zio.aws.lightsail.model.EndpointRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest
  ): zio.aws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly =
    new Wrapper(impl)
}
