package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerServiceEndpoint(
    containerName: Optional[String] = Optional.Absent,
    containerPort: Optional[Integer] = Optional.Absent,
    healthCheck: Optional[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint = {
    import ContainerServiceEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
      .builder()
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(containerPort.map(value => value: java.lang.Integer))(
        _.containerPort
      )
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceEndpoint.wrap(buildAwsValue())
}
object ContainerServiceEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceEndpoint =
      zio.aws.lightsail.model.ContainerServiceEndpoint(
        containerName.map(value => value),
        containerPort.map(value => value),
        healthCheck.map(value => value.asEditable)
      )
    def containerName: Optional[String]
    def containerPort: Optional[Integer]
    def healthCheck: Optional[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ]
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ) extends zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly {
    override val containerName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => value: String)
    override val containerPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPort())
      .map(value => value: Integer)
    override val healthCheck: Optional[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheck())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ): zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly = new Wrapper(
    impl
  )
}
