package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CookieObject(
    option: Optional[zio.aws.lightsail.model.ForwardValues] = Optional.Absent,
    cookiesAllowList: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CookieObject = {
    import CookieObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CookieObject
      .builder()
      .optionallyWith(option.map(value => value.unwrap))(_.option)
      .optionallyWith(
        cookiesAllowList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cookiesAllowList)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CookieObject.ReadOnly =
    zio.aws.lightsail.model.CookieObject.wrap(buildAwsValue())
}
object CookieObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CookieObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CookieObject =
      zio.aws.lightsail.model.CookieObject(
        option.map(value => value),
        cookiesAllowList.map(value => value)
      )
    def option: Optional[zio.aws.lightsail.model.ForwardValues]
    def cookiesAllowList: Optional[List[String]]
    def getOption: ZIO[Any, AwsError, zio.aws.lightsail.model.ForwardValues] =
      AwsError.unwrapOptionField("option", option)
    def getCookiesAllowList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cookiesAllowList", cookiesAllowList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CookieObject
  ) extends zio.aws.lightsail.model.CookieObject.ReadOnly {
    override val option: Optional[zio.aws.lightsail.model.ForwardValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.option())
        .map(value => zio.aws.lightsail.model.ForwardValues.wrap(value))
    override val cookiesAllowList: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cookiesAllowList())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CookieObject
  ): zio.aws.lightsail.model.CookieObject.ReadOnly = new Wrapper(impl)
}
