package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.StringMax256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateContactMethodRequest(
    protocol: zio.aws.lightsail.model.ContactProtocol,
    contactEndpoint: StringMax256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest = {
    import CreateContactMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest
      .builder()
      .protocol(protocol.unwrap)
      .contactEndpoint(StringMax256.unwrap(contactEndpoint): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateContactMethodRequest.ReadOnly =
    zio.aws.lightsail.model.CreateContactMethodRequest.wrap(buildAwsValue())
}
object CreateContactMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateContactMethodRequest =
      zio.aws.lightsail.model
        .CreateContactMethodRequest(protocol, contactEndpoint)
    def protocol: zio.aws.lightsail.model.ContactProtocol
    def contactEndpoint: StringMax256
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.lightsail.model.ContactProtocol] =
      ZIO.succeed(protocol)
    def getContactEndpoint: ZIO[Any, Nothing, StringMax256] =
      ZIO.succeed(contactEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest
  ) extends zio.aws.lightsail.model.CreateContactMethodRequest.ReadOnly {
    override val protocol: zio.aws.lightsail.model.ContactProtocol =
      zio.aws.lightsail.model.ContactProtocol.wrap(impl.protocol())
    override val contactEndpoint: StringMax256 =
      zio.aws.lightsail.model.primitives.StringMax256(impl.contactEndpoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest
  ): zio.aws.lightsail.model.CreateContactMethodRequest.ReadOnly = new Wrapper(
    impl
  )
}
