package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDistributionResponse(
    distribution: Optional[zio.aws.lightsail.model.LightsailDistribution] =
      Optional.Absent,
    operation: Optional[zio.aws.lightsail.model.Operation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse = {
    import CreateDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
      .builder()
      .optionallyWith(distribution.map(value => value.buildAwsValue()))(
        _.distribution
      )
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly =
    zio.aws.lightsail.model.CreateDistributionResponse.wrap(buildAwsValue())
}
object CreateDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDistributionResponse =
      zio.aws.lightsail.model.CreateDistributionResponse(
        distribution.map(value => value.asEditable),
        operation.map(value => value.asEditable)
      )
    def distribution
        : Optional[zio.aws.lightsail.model.LightsailDistribution.ReadOnly]
    def operation: Optional[zio.aws.lightsail.model.Operation.ReadOnly]
    def getDistribution: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LightsailDistribution.ReadOnly
    ] = AwsError.unwrapOptionField("distribution", distribution)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ) extends zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly {
    override val distribution
        : Optional[zio.aws.lightsail.model.LightsailDistribution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distribution())
        .map(value => zio.aws.lightsail.model.LightsailDistribution.wrap(value))
    override val operation
        : Optional[zio.aws.lightsail.model.Operation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ): zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly = new Wrapper(
    impl
  )
}
