package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDomainRequest(
    domainName: DomainName,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDomainRequest = {
    import CreateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateDomainRequest.ReadOnly =
    zio.aws.lightsail.model.CreateDomainRequest.wrap(buildAwsValue())
}
object CreateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDomainRequest =
      zio.aws.lightsail.model.CreateDomainRequest(
        domainName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainName: DomainName
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainRequest
  ) extends zio.aws.lightsail.model.CreateDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.lightsail.model.primitives.DomainName(impl.domainName())
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainRequest
  ): zio.aws.lightsail.model.CreateDomainRequest.ReadOnly = new Wrapper(impl)
}
