package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDiskSnapshotRequest(diskSnapshotName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest = {
    import DeleteDiskSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest
      .builder()
      .diskSnapshotName(ResourceName.unwrap(diskSnapshotName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteDiskSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteDiskSnapshotRequest.wrap(buildAwsValue())
}
object DeleteDiskSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteDiskSnapshotRequest =
      zio.aws.lightsail.model.DeleteDiskSnapshotRequest(diskSnapshotName)
    def diskSnapshotName: ResourceName
    def getDiskSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(diskSnapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest
  ) extends zio.aws.lightsail.model.DeleteDiskSnapshotRequest.ReadOnly {
    override val diskSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskSnapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest
  ): zio.aws.lightsail.model.DeleteDiskSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
