package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDomainEntryRequest(
    domainName: DomainName,
    domainEntry: zio.aws.lightsail.model.DomainEntry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest = {
    import DeleteDomainEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .domainEntry(domainEntry.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteDomainEntryRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteDomainEntryRequest.wrap(buildAwsValue())
}
object DeleteDomainEntryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteDomainEntryRequest =
      zio.aws.lightsail.model
        .DeleteDomainEntryRequest(domainName, domainEntry.asEditable)
    def domainName: DomainName
    def domainEntry: zio.aws.lightsail.model.DomainEntry.ReadOnly
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getDomainEntry
        : ZIO[Any, Nothing, zio.aws.lightsail.model.DomainEntry.ReadOnly] =
      ZIO.succeed(domainEntry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest
  ) extends zio.aws.lightsail.model.DeleteDomainEntryRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.lightsail.model.primitives.DomainName(impl.domainName())
    override val domainEntry: zio.aws.lightsail.model.DomainEntry.ReadOnly =
      zio.aws.lightsail.model.DomainEntry.wrap(impl.domainEntry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest
  ): zio.aws.lightsail.model.DeleteDomainEntryRequest.ReadOnly = new Wrapper(
    impl
  )
}
