package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    skipFinalSnapshot: Optional[Boolean] = Optional.Absent,
    finalRelationalDatabaseSnapshotName: Optional[ResourceName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest = {
    import DeleteRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(
        _.skipFinalSnapshot
      )
      .optionallyWith(
        finalRelationalDatabaseSnapshotName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.finalRelationalDatabaseSnapshotName)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DeleteRelationalDatabaseRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object DeleteRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteRelationalDatabaseRequest =
      zio.aws.lightsail.model.DeleteRelationalDatabaseRequest(
        relationalDatabaseName,
        skipFinalSnapshot.map(value => value),
        finalRelationalDatabaseSnapshotName.map(value => value)
      )
    def relationalDatabaseName: ResourceName
    def skipFinalSnapshot: Optional[Boolean]
    def finalRelationalDatabaseSnapshotName: Optional[ResourceName]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getSkipFinalSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshot)
    def getFinalRelationalDatabaseSnapshotName
        : ZIO[Any, AwsError, ResourceName] = AwsError.unwrapOptionField(
      "finalRelationalDatabaseSnapshotName",
      finalRelationalDatabaseSnapshotName
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest
  ) extends zio.aws.lightsail.model.DeleteRelationalDatabaseRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val skipFinalSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.skipFinalSnapshot())
      .map(value => value: Boolean)
    override val finalRelationalDatabaseSnapshotName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalRelationalDatabaseSnapshotName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest
  ): zio.aws.lightsail.model.DeleteRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
