package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DetachCertificateFromDistributionRequest(
    distributionName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest = {
    import DetachCertificateFromDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest
      .builder()
      .distributionName(ResourceName.unwrap(distributionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DetachCertificateFromDistributionRequest.ReadOnly =
    zio.aws.lightsail.model.DetachCertificateFromDistributionRequest
      .wrap(buildAwsValue())
}
object DetachCertificateFromDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.DetachCertificateFromDistributionRequest =
      zio.aws.lightsail.model
        .DetachCertificateFromDistributionRequest(distributionName)
    def distributionName: ResourceName
    def getDistributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest
  ) extends zio.aws.lightsail.model.DetachCertificateFromDistributionRequest.ReadOnly {
    override val distributionName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.distributionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest
  ): zio.aws.lightsail.model.DetachCertificateFromDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
