package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{ResourceName, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DiskMap(
    originalDiskPath: Optional[NonEmptyString] = Optional.Absent,
    newDiskName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskMap = {
    import DiskMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskMap
      .builder()
      .optionallyWith(
        originalDiskPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.originalDiskPath)
      .optionallyWith(
        newDiskName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.newDiskName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DiskMap.ReadOnly =
    zio.aws.lightsail.model.DiskMap.wrap(buildAwsValue())
}
object DiskMap {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.DiskMap] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DiskMap =
      zio.aws.lightsail.model.DiskMap(
        originalDiskPath.map(value => value),
        newDiskName.map(value => value)
      )
    def originalDiskPath: Optional[NonEmptyString]
    def newDiskName: Optional[ResourceName]
    def getOriginalDiskPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originalDiskPath", originalDiskPath)
    def getNewDiskName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("newDiskName", newDiskName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskMap
  ) extends zio.aws.lightsail.model.DiskMap.ReadOnly {
    override val originalDiskPath: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originalDiskPath())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val newDiskName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.newDiskName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskMap
  ): zio.aws.lightsail.model.DiskMap.ReadOnly = new Wrapper(impl)
}
