package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  DomainEntryOptionsKeys,
  DomainEntryType,
  DomainName,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DomainEntry(
    id: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[DomainName] = Optional.Absent,
    target: Optional[String] = Optional.Absent,
    isAlias: Optional[Boolean] = Optional.Absent,
    `type`: Optional[DomainEntryType] = Optional.Absent,
    options: Optional[Map[DomainEntryOptionsKeys, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DomainEntry = {
    import DomainEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DomainEntry
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(target.map(value => value: java.lang.String))(_.target)
      .optionallyWith(isAlias.map(value => value: java.lang.Boolean))(_.isAlias)
      .optionallyWith(
        `type`.map(value => DomainEntryType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              (DomainEntryOptionsKeys
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.options)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DomainEntry.ReadOnly =
    zio.aws.lightsail.model.DomainEntry.wrap(buildAwsValue())
}
object DomainEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DomainEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DomainEntry =
      zio.aws.lightsail.model.DomainEntry(
        id.map(value => value),
        name.map(value => value),
        target.map(value => value),
        isAlias.map(value => value),
        `type`.map(value => value),
        options.map(value => value)
      )
    def id: Optional[NonEmptyString]
    def name: Optional[DomainName]
    def target: Optional[String]
    def isAlias: Optional[Boolean]
    def `type`: Optional[DomainEntryType]
    def options: Optional[Map[DomainEntryOptionsKeys, String]]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("name", name)
    def getTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("target", target)
    def getIsAlias: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAlias", isAlias)
    def getType: ZIO[Any, AwsError, DomainEntryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOptions: ZIO[Any, AwsError, Map[DomainEntryOptionsKeys, String]] =
      AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DomainEntry
  ) extends zio.aws.lightsail.model.DomainEntry.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val name: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val target: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value => value: String)
    override val isAlias: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAlias())
      .map(value => value: Boolean)
    override val `type`: Optional[DomainEntryType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.lightsail.model.primitives.DomainEntryType(value))
    override val options: Optional[Map[DomainEntryOptionsKeys, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lightsail.model.primitives
                .DomainEntryOptionsKeys(key) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DomainEntry
  ): zio.aws.lightsail.model.DomainEntry.ReadOnly = new Wrapper(impl)
}
