package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, Base64}
import scala.jdk.CollectionConverters._
final case class DownloadDefaultKeyPairResponse(
    publicKeyBase64: Optional[Base64] = Optional.Absent,
    privateKeyBase64: Optional[Base64] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse = {
    import DownloadDefaultKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
      .builder()
      .optionallyWith(
        publicKeyBase64.map(value => Base64.unwrap(value): java.lang.String)
      )(_.publicKeyBase64)
      .optionallyWith(
        privateKeyBase64.map(value => Base64.unwrap(value): java.lang.String)
      )(_.privateKeyBase64)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly =
    zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.wrap(buildAwsValue())
}
object DownloadDefaultKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DownloadDefaultKeyPairResponse =
      zio.aws.lightsail.model.DownloadDefaultKeyPairResponse(
        publicKeyBase64.map(value => value),
        privateKeyBase64.map(value => value),
        createdAt.map(value => value)
      )
    def publicKeyBase64: Optional[Base64]
    def privateKeyBase64: Optional[Base64]
    def createdAt: Optional[IsoDate]
    def getPublicKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("publicKeyBase64", publicKeyBase64)
    def getPrivateKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("privateKeyBase64", privateKeyBase64)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ) extends zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly {
    override val publicKeyBase64: Optional[Base64] = zio.aws.core.internal
      .optionalFromNullable(impl.publicKeyBase64())
      .map(value => zio.aws.lightsail.model.primitives.Base64(value))
    override val privateKeyBase64: Optional[Base64] = zio.aws.core.internal
      .optionalFromNullable(impl.privateKeyBase64())
      .map(value => zio.aws.lightsail.model.primitives.Base64(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ): zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly =
    new Wrapper(impl)
}
