package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBlueprintsRequest(
    includeInactive: Optional[Boolean] = Optional.Absent,
    pageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest = {
    import GetBlueprintsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest
      .builder()
      .optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(
        _.includeInactive
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBlueprintsRequest.ReadOnly =
    zio.aws.lightsail.model.GetBlueprintsRequest.wrap(buildAwsValue())
}
object GetBlueprintsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBlueprintsRequest =
      zio.aws.lightsail.model.GetBlueprintsRequest(
        includeInactive.map(value => value),
        pageToken.map(value => value)
      )
    def includeInactive: Optional[Boolean]
    def pageToken: Optional[String]
    def getIncludeInactive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeInactive", includeInactive)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest
  ) extends zio.aws.lightsail.model.GetBlueprintsRequest.ReadOnly {
    override val includeInactive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeInactive())
      .map(value => value: Boolean)
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest
  ): zio.aws.lightsail.model.GetBlueprintsRequest.ReadOnly = new Wrapper(impl)
}
