package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBlueprintsResponse(
    blueprints: Optional[Iterable[zio.aws.lightsail.model.Blueprint]] =
      Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse = {
    import GetBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse
      .builder()
      .optionallyWith(
        blueprints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blueprints)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBlueprintsResponse.ReadOnly =
    zio.aws.lightsail.model.GetBlueprintsResponse.wrap(buildAwsValue())
}
object GetBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBlueprintsResponse =
      zio.aws.lightsail.model.GetBlueprintsResponse(
        blueprints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def blueprints: Optional[List[zio.aws.lightsail.model.Blueprint.ReadOnly]]
    def nextPageToken: Optional[String]
    def getBlueprints
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Blueprint.ReadOnly]] =
      AwsError.unwrapOptionField("blueprints", blueprints)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse
  ) extends zio.aws.lightsail.model.GetBlueprintsResponse.ReadOnly {
    override val blueprints
        : Optional[List[zio.aws.lightsail.model.Blueprint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blueprints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Blueprint.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse
  ): zio.aws.lightsail.model.GetBlueprintsResponse.ReadOnly = new Wrapper(impl)
}
