package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketBundlesRequest(
    includeInactive: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest = {
    import GetBucketBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest
      .builder()
      .optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(
        _.includeInactive
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketBundlesRequest.ReadOnly =
    zio.aws.lightsail.model.GetBucketBundlesRequest.wrap(buildAwsValue())
}
object GetBucketBundlesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketBundlesRequest =
      zio.aws.lightsail.model
        .GetBucketBundlesRequest(includeInactive.map(value => value))
    def includeInactive: Optional[Boolean]
    def getIncludeInactive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeInactive", includeInactive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest
  ) extends zio.aws.lightsail.model.GetBucketBundlesRequest.ReadOnly {
    override val includeInactive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeInactive())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest
  ): zio.aws.lightsail.model.GetBucketBundlesRequest.ReadOnly = new Wrapper(
    impl
  )
}
