package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetContainerImagesRequest(serviceName: ContainerServiceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest = {
    import GetContainerImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetContainerImagesRequest.ReadOnly =
    zio.aws.lightsail.model.GetContainerImagesRequest.wrap(buildAwsValue())
}
object GetContainerImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerImagesRequest =
      zio.aws.lightsail.model.GetContainerImagesRequest(serviceName)
    def serviceName: ContainerServiceName
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest
  ) extends zio.aws.lightsail.model.GetContainerImagesRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest
  ): zio.aws.lightsail.model.GetContainerImagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
