package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContainerServiceMetricDataResponse(
    metricName: Optional[zio.aws.lightsail.model.ContainerServiceMetricName] =
      Optional.Absent,
    metricData: Optional[Iterable[zio.aws.lightsail.model.MetricDatapoint]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse = {
    import GetContainerServiceMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(
        metricData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricData)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly =
    zio.aws.lightsail.model.GetContainerServiceMetricDataResponse
      .wrap(buildAwsValue())
}
object GetContainerServiceMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetContainerServiceMetricDataResponse =
      zio.aws.lightsail.model.GetContainerServiceMetricDataResponse(
        metricName.map(value => value),
        metricData.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Optional[zio.aws.lightsail.model.ContainerServiceMetricName]
    def metricData
        : Optional[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]]
    def getMetricName: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceMetricName
    ] = AwsError.unwrapOptionField("metricName", metricName)
    def getMetricData: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.MetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricData", metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse
  ) extends zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly {
    override val metricName
        : Optional[zio.aws.lightsail.model.ContainerServiceMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceMetricName.wrap(value)
        )
    override val metricData
        : Optional[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.MetricDatapoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse
  ): zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
