package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDiskSnapshotRequest(diskSnapshotName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest = {
    import GetDiskSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest
      .builder()
      .diskSnapshotName(ResourceName.unwrap(diskSnapshotName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDiskSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.GetDiskSnapshotRequest.wrap(buildAwsValue())
}
object GetDiskSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDiskSnapshotRequest =
      zio.aws.lightsail.model.GetDiskSnapshotRequest(diskSnapshotName)
    def diskSnapshotName: ResourceName
    def getDiskSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(diskSnapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest
  ) extends zio.aws.lightsail.model.GetDiskSnapshotRequest.ReadOnly {
    override val diskSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskSnapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest
  ): zio.aws.lightsail.model.GetDiskSnapshotRequest.ReadOnly = new Wrapper(impl)
}
