package zio.aws.lightsail.model
import java.time.Instant
import zio.aws.core.BuilderHelper
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  MetricPeriod,
  Timestamp,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetDistributionMetricDataRequest(
    distributionName: ResourceName,
    metricName: zio.aws.lightsail.model.DistributionMetricName,
    startTime: Timestamp,
    endTime: Timestamp,
    period: MetricPeriod,
    unit: zio.aws.lightsail.model.MetricUnit,
    statistics: Iterable[zio.aws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest = {
    import GetDistributionMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest
      .builder()
      .distributionName(ResourceName.unwrap(distributionName): java.lang.String)
      .metricName(metricName.unwrap)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .period(MetricPeriod.unwrap(period): Integer)
      .unit(unit.unwrap)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetDistributionMetricDataRequest.ReadOnly =
    zio.aws.lightsail.model.GetDistributionMetricDataRequest
      .wrap(buildAwsValue())
}
object GetDistributionMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDistributionMetricDataRequest =
      zio.aws.lightsail.model.GetDistributionMetricDataRequest(
        distributionName,
        metricName,
        startTime,
        endTime,
        period,
        unit,
        statistics
      )
    def distributionName: ResourceName
    def metricName: zio.aws.lightsail.model.DistributionMetricName
    def startTime: Timestamp
    def endTime: Timestamp
    def period: MetricPeriod
    def unit: zio.aws.lightsail.model.MetricUnit
    def statistics: List[zio.aws.lightsail.model.MetricStatistic]
    def getDistributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionName)
    def getMetricName
        : ZIO[Any, Nothing, zio.aws.lightsail.model.DistributionMetricName] =
      ZIO.succeed(metricName)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getPeriod: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(period)
    def getUnit: ZIO[Any, Nothing, zio.aws.lightsail.model.MetricUnit] =
      ZIO.succeed(unit)
    def getStatistics
        : ZIO[Any, Nothing, List[zio.aws.lightsail.model.MetricStatistic]] =
      ZIO.succeed(statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest
  ) extends zio.aws.lightsail.model.GetDistributionMetricDataRequest.ReadOnly {
    override val distributionName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.distributionName())
    override val metricName: zio.aws.lightsail.model.DistributionMetricName =
      zio.aws.lightsail.model.DistributionMetricName.wrap(impl.metricName())
    override val startTime: Timestamp =
      zio.aws.lightsail.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.lightsail.model.primitives.Timestamp(impl.endTime())
    override val period: MetricPeriod =
      zio.aws.lightsail.model.primitives.MetricPeriod(impl.period())
    override val unit: zio.aws.lightsail.model.MetricUnit =
      zio.aws.lightsail.model.MetricUnit.wrap(impl.unit())
    override val statistics: List[zio.aws.lightsail.model.MetricStatistic] =
      impl
        .statistics()
        .asScala
        .map { item =>
          zio.aws.lightsail.model.MetricStatistic.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest
  ): zio.aws.lightsail.model.GetDistributionMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
