package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDomainRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDomainRequest = {
    import GetDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDomainRequest.ReadOnly =
    zio.aws.lightsail.model.GetDomainRequest.wrap(buildAwsValue())
}
object GetDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDomainRequest =
      zio.aws.lightsail.model.GetDomainRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainRequest
  ) extends zio.aws.lightsail.model.GetDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.lightsail.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainRequest
  ): zio.aws.lightsail.model.GetDomainRequest.ReadOnly = new Wrapper(impl)
}
