package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInstanceResponse(
    instance: Optional[zio.aws.lightsail.model.Instance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceResponse = {
    import GetInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceResponse
      .builder()
      .optionallyWith(instance.map(value => value.buildAwsValue()))(_.instance)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetInstanceResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstanceResponse.wrap(buildAwsValue())
}
object GetInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceResponse =
      zio.aws.lightsail.model
        .GetInstanceResponse(instance.map(value => value.asEditable))
    def instance: Optional[zio.aws.lightsail.model.Instance.ReadOnly]
    def getInstance
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Instance.ReadOnly] =
      AwsError.unwrapOptionField("instance", instance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceResponse
  ) extends zio.aws.lightsail.model.GetInstanceResponse.ReadOnly {
    override val instance: Optional[zio.aws.lightsail.model.Instance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instance())
        .map(value => zio.aws.lightsail.model.Instance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceResponse
  ): zio.aws.lightsail.model.GetInstanceResponse.ReadOnly = new Wrapper(impl)
}
