package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetKeyPairsRequest(
    pageToken: Optional[String] = Optional.Absent,
    includeDefaultKeyPair: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest = {
    import GetKeyPairsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .optionallyWith(
        includeDefaultKeyPair.map(value => value: java.lang.Boolean)
      )(_.includeDefaultKeyPair)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetKeyPairsRequest.ReadOnly =
    zio.aws.lightsail.model.GetKeyPairsRequest.wrap(buildAwsValue())
}
object GetKeyPairsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetKeyPairsRequest =
      zio.aws.lightsail.model.GetKeyPairsRequest(
        pageToken.map(value => value),
        includeDefaultKeyPair.map(value => value)
      )
    def pageToken: Optional[String]
    def includeDefaultKeyPair: Optional[Boolean]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getIncludeDefaultKeyPair: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeDefaultKeyPair", includeDefaultKeyPair)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest
  ) extends zio.aws.lightsail.model.GetKeyPairsRequest.ReadOnly {
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
    override val includeDefaultKeyPair: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeDefaultKeyPair())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest
  ): zio.aws.lightsail.model.GetKeyPairsRequest.ReadOnly = new Wrapper(impl)
}
