package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLoadBalancerResponse(
    loadBalancer: Optional[zio.aws.lightsail.model.LoadBalancer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse = {
    import GetLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse
      .builder()
      .optionallyWith(loadBalancer.map(value => value.buildAwsValue()))(
        _.loadBalancer
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetLoadBalancerResponse.ReadOnly =
    zio.aws.lightsail.model.GetLoadBalancerResponse.wrap(buildAwsValue())
}
object GetLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetLoadBalancerResponse =
      zio.aws.lightsail.model
        .GetLoadBalancerResponse(loadBalancer.map(value => value.asEditable))
    def loadBalancer: Optional[zio.aws.lightsail.model.LoadBalancer.ReadOnly]
    def getLoadBalancer
        : ZIO[Any, AwsError, zio.aws.lightsail.model.LoadBalancer.ReadOnly] =
      AwsError.unwrapOptionField("loadBalancer", loadBalancer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse
  ) extends zio.aws.lightsail.model.GetLoadBalancerResponse.ReadOnly {
    override val loadBalancer
        : Optional[zio.aws.lightsail.model.LoadBalancer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancer())
        .map(value => zio.aws.lightsail.model.LoadBalancer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse
  ): zio.aws.lightsail.model.GetLoadBalancerResponse.ReadOnly = new Wrapper(
    impl
  )
}
