package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetOperationsResponse(
    operations: Optional[Iterable[zio.aws.lightsail.model.Operation]] =
      Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetOperationsResponse = {
    import GetOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetOperationsResponse.ReadOnly =
    zio.aws.lightsail.model.GetOperationsResponse.wrap(buildAwsValue())
}
object GetOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetOperationsResponse =
      zio.aws.lightsail.model.GetOperationsResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def operations: Optional[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def nextPageToken: Optional[String]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsResponse
  ) extends zio.aws.lightsail.model.GetOperationsResponse.ReadOnly {
    override val operations
        : Optional[List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Operation.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsResponse
  ): zio.aws.lightsail.model.GetOperationsResponse.ReadOnly = new Wrapper(impl)
}
