package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRegionsResponse(
    regions: Optional[Iterable[zio.aws.lightsail.model.Region]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRegionsResponse = {
    import GetRegionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRegionsResponse
      .builder()
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetRegionsResponse.ReadOnly =
    zio.aws.lightsail.model.GetRegionsResponse.wrap(buildAwsValue())
}
object GetRegionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRegionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetRegionsResponse =
      zio.aws.lightsail.model.GetRegionsResponse(
        regions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def regions: Optional[List[zio.aws.lightsail.model.Region.ReadOnly]]
    def getRegions
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Region.ReadOnly]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRegionsResponse
  ) extends zio.aws.lightsail.model.GetRegionsResponse.ReadOnly {
    override val regions
        : Optional[List[zio.aws.lightsail.model.Region.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Region.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRegionsResponse
  ): zio.aws.lightsail.model.GetRegionsResponse.ReadOnly = new Wrapper(impl)
}
