package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStaticIpsRequest(
    pageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest = {
    import GetStaticIpsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetStaticIpsRequest.ReadOnly =
    zio.aws.lightsail.model.GetStaticIpsRequest.wrap(buildAwsValue())
}
object GetStaticIpsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetStaticIpsRequest =
      zio.aws.lightsail.model.GetStaticIpsRequest(pageToken.map(value => value))
    def pageToken: Optional[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest
  ) extends zio.aws.lightsail.model.GetStaticIpsRequest.ReadOnly {
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest
  ): zio.aws.lightsail.model.GetStaticIpsRequest.ReadOnly = new Wrapper(impl)
}
