package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStaticIpsResponse(
    staticIps: Optional[Iterable[zio.aws.lightsail.model.StaticIp]] =
      Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse = {
    import GetStaticIpsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse
      .builder()
      .optionallyWith(
        staticIps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.staticIps)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetStaticIpsResponse.ReadOnly =
    zio.aws.lightsail.model.GetStaticIpsResponse.wrap(buildAwsValue())
}
object GetStaticIpsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetStaticIpsResponse =
      zio.aws.lightsail.model.GetStaticIpsResponse(
        staticIps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def staticIps: Optional[List[zio.aws.lightsail.model.StaticIp.ReadOnly]]
    def nextPageToken: Optional[String]
    def getStaticIps
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.StaticIp.ReadOnly]] =
      AwsError.unwrapOptionField("staticIps", staticIps)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse
  ) extends zio.aws.lightsail.model.GetStaticIpsResponse.ReadOnly {
    override val staticIps
        : Optional[List[zio.aws.lightsail.model.StaticIp.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.staticIps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.StaticIp.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse
  ): zio.aws.lightsail.model.GetStaticIpsResponse.ReadOnly = new Wrapper(impl)
}
