package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportKeyPairResponse(
    operation: Optional[zio.aws.lightsail.model.Operation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse = {
    import ImportKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly =
    zio.aws.lightsail.model.ImportKeyPairResponse.wrap(buildAwsValue())
}
object ImportKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ImportKeyPairResponse =
      zio.aws.lightsail.model
        .ImportKeyPairResponse(operation.map(value => value.asEditable))
    def operation: Optional[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ) extends zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly {
    override val operation
        : Optional[zio.aws.lightsail.model.Operation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ): zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly = new Wrapper(impl)
}
